module.exports = {

    validarCPF(cpf) {

    cpf = cpf.replace(/[^\d]+/g, '');


    if (cpf.length !== 11) return false;


    if (/^(\d)\1+$/.test(cpf)) return false;

    function calcularDigito(baseCpf, fatorInicial) {
        let soma = 0;
        for (let i = 0; i < baseCpf.length; i++) {
            soma += baseCpf[i] * fatorInicial--;
        }
        let resto = (soma * 10) % 11;
        return resto === 10 || resto === 11 ? 0 : resto;
    }

    const primeiroDigito = calcularDigito(cpf.substring(0, 9), 10);
    if (primeiroDigito !== parseInt(cpf[9])) return false;

    const segundoDigito = calcularDigito(cpf.substring(0, 10), 11);
    if (segundoDigito !== parseInt(cpf[10])) return false;

    return true;
}

}