const fs = require('fs');
const path = require('path');
const nodemailer = require('nodemailer');
require('dotenv').config({path:__dirname+'/../../.env'});

const email_sender   = process.env.EMAIL_SENDER ?? "";
const email_password = process.env.EMAIL_PASSWORD ?? "";
const email_host     = process.env.EMAIL_HOST ?? "";

async function enviarEmail(cliente) {

  const templatePath = path.join(__dirname, '../templates/statusCotacao.html');
  let templateHtml = fs.readFileSync(templatePath, 'utf-8');

    templateHtml = templateHtml
    .replace(/{{fornecedor}}/g, cliente.fornecedor)
    .replace(/{{id_cotacao}}/g, cliente.id_cotacao);

  
  const transporter = nodemailer.createTransport({
    host: `${email_host}`,
    port: 465,
    secure: true,
    auth: {
      user: `${email_sender}`,
      pass: `${email_password}`,
    },
  });


  const mailOptions = {
    from: `${email_sender}`,
    to: cliente.email,
    subject: "Atualização da Cotação",
    html: templateHtml,
  };

  try {
    const info = await transporter.sendMail(mailOptions);
    console.log("E-mail enviado:", info);
    return { success: true, message: "E-mail enviado com sucesso!", code: 200 };
  } catch (error) {
    console.error("Erro ao enviar e-mail:", error);
    return { error: true, message: "Erro ao enviar e-mail", code: 500 };
  }
}

module.exports = { enviarEmail };
