const Recebimento = require("./recebimentos.repository");


class RecebimentosController {
  #recebimentos;
    constructor(recebimentosRepository = new Recebimento()) {
    this.#recebimentos = recebimentosRepository;
  }


  /**
   * Realiza o login de um usuário
   * @returns mensagem referente ao resultado obtido
   */
  login() {
    return async (req, res) => {
      try {
        const data = req.body;
        const ip = req.headers["x-forwarded-for"] || req.connection.remoteAddress;

        const response = await this.#recebimentos.login(data, ip);
        if (response.error) return res.status(response.code).json(response);

        return res.status(200).json(response);
      } catch (error) {
        console.error(error);
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Registra um usuário
   */
  register() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#recebimentos.register(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(response.code).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }



  /**
   * Realiza o logout do usuário
   */
  logout() {
    return async (req, res) => {
      try {
        const user = req.user
        const response = await this.#recebimentos.logout(user);

        return res.status(response.code).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Lista todos os usuários
   */
  getRecebimentos() {
    return async (req, res) => {
      try {
        const response = await this.#recebimentos.getRecebimentos();
        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }


  getUmRecebimento() {
    return async (req, res) => {
      try {

        const id = req.params.id;

        const response = await this.#recebimentos.getUmRecebimento(id);

        return res.status(200).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Deleta um usuário
   */
  delete() {
    return async (req, res) => {
      try {
        const id = req.params.id;
        console.log(id);
        
        const response = await this.#recebimentos.delete(id);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Atualiza os dados de um usuário
   */
  update() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#recebimentos.update(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

}
module.exports = RecebimentosController;

