const express = require("express");
const routes = express.Router();
const multer = require("multer");

const storage = multer.memoryStorage();


const upload = multer({ 
    storage,
    dest: "uploads/"
})

const PlantasController = require("./plantas.controller");
const plantasController = new PlantasController();

routes.post("/", upload.single("file"), plantasController.register());
routes.get("/", plantasController.getPlantas());
routes.get("/:id", plantasController.getUmaPlanta());
routes.delete("/:id", plantasController.delete());
routes.patch("/", upload.single("file"), plantasController.update());


module.exports = routes;