const PlantasRepository = require("./plantas.repository");

class PlantasController {
  #plantas;

  constructor(plantasRepository = new PlantasRepository()) {
    this.#plantas = plantasRepository;
  }

  /**
   * Cadastra uma planta (sem arquivo)
   */
  register() {
    return async (req, res) => {
      try {
        const data = req.body;
        const file = req.file;
        const response = await this.#plantas.register(data, file);

        if (response.error)
          return res.status(response.code).json(response);

        return res.status(response.code).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Lista todas as plantas
   */
  getPlantas() {
    return async (req, res) => {
      try {
        const response = await this.#plantas.getPlantas();

        if (response.error)
          return res.status(response.code).json(response);

        return res.status(200).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Retorna uma planta pelo ID
   */
  getUmaPlanta() {
    return async (req, res) => {
      try {
        const id = req.params.id;

        const response = await this.#plantas.getUmaPlanta(id);

        return res.status(200).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Deleta uma planta
   */
  delete() {
    return async (req, res) => {
      try {
        const id = req.params.id;

        const response = await this.#plantas.delete(id);

        if (response.error)
          return res.status(response.code).json(response);

        return res.status(200).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Atualiza uma planta
   */
  update() {
    return async (req, res) => {
      try {
        const data = req.body;
        const file = req.file;

        const response = await this.#plantas.update(data, file);

        if (response.error)
          return res.status(response.code).json(response);

        return res.status(200).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Upload de arquivo da planta (PDF, imagem, DWG, etc.)
   */
  uploadPlanta() {
    return async (req, res) => {
      try {
        const file = req.file;
        const id_empresa = req.body.id_empresa;

        const response = await this.#plantas.uploadPlanta(file, id_empresa);

        if (response.error)
          return res.status(response.code).json(response);

        return res.status(200).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }
}

module.exports = PlantasController;
