const express = require("express");
const routes = express.Router();
const multer = require("multer");
const {
  verifyToken,
  isEmpresa,
} = require("../auth/middlewares/authMiddleware");

const storage = multer.memoryStorage();

const upload = multer({
  storage,
  dest: "uploads/",
});

const PedidosController = require("./pedidos.controller");
const pedidosController = new PedidosController();

routes.post(
  "/",
  upload.any(),
  verifyToken,
  isEmpresa,
  pedidosController.register(),
);

routes.post("/voltar-cotado/:id_pedido", pedidosController.voltarCotado());

routes.get(
  "/itens/:id_pedido/fornecedor/:id_fornecedor",
  pedidosController.getUmPedidoComItensDeForncedor(),
);
routes.get(
  "/itens/aprovados/:id_pedido/fornecedor/:id_fornecedor",
  pedidosController.getUmPedidoComItensDeForncedorAprovado(),
);
routes.get(
  "/fornecedor/:id_fornecedor",
  pedidosController.getPedidosDeFornecedor(),
);
routes.get(
  "/fornecedor/:id_fornecedor/aprovados",
  pedidosController.getPedidosDeFornecedorAprovado(),
);
routes.patch("/alterarStatus", pedidosController.alterarStatusPedido());
routes.post("/analise", pedidosController.salvarDecisoesPedido());
routes.post(
  "/recebimento/confirmado",
  upload.any(),
  pedidosController.recebimentoConfirmado(),
);
routes.patch(
  "/cancela-reenvia-item/:id_item",
  pedidosController.cancelaItemOuReenvia(),
);
routes.get("/pendentes", pedidosController.getPendenteEntrega());
routes.get(
  "/itens/pendentes/:id_pedido",
  pedidosController.getItensPendentesEntrega(),
);
routes.get("/:id_pedido/analise", pedidosController.getPedidosGestor());
routes.post("/cotacoes/resposta", pedidosController.responderCotacao());
routes.post("/cotacoes/enviar-item", pedidosController.cotacao());
routes.post("/enviar", pedidosController.enviar());
routes.get("/empresa/:id_empresa", pedidosController.getPedidosDeEmpresa());
routes.get("/itens/:id_pedido", pedidosController.getUmPedidoComItens());
routes.get("/cotacao/:id_pedido", pedidosController.getCotacao());
routes.get(
  "/cotacao/:id_pedido/reprovados",
  pedidosController.getCotacaoReprovado(),
);
routes.get(
  "/cotacao/:id_pedido/retornar",
  pedidosController.getCotacoRetornar(),
);
routes.get("/transito", pedidosController.getTransito());
routes.get("/transito/:id_pedido", pedidosController.getItensTransito());
routes.get("/aprovados", pedidosController.getPedidosAprovados());
routes.get(
  "/itens-aprovados/:id_pedido",
  pedidosController.getItensAprovados(),
);

// routes.get("/")
//routes.get("/pendentes", pedidosController.getPedidosPendentes());
routes.get(
  "/aprovadogestor/:id_fornecedor",
  pedidosController.getPedidosAprovadosGestor(),
);
routes.get("/aprovacao", pedidosController.getPedidosAprovacao());
routes.get("/", pedidosController.getPedidos());
routes.get("/itens/:id_pedido", pedidosController.getItensPedido());
routes.get("/:id", pedidosController.getUmPedido());
routes.delete("/:id", pedidosController.delete());
routes.delete("/cotacoes/:id", pedidosController.deletarCotacao());
routes.patch("/", pedidosController.update());
routes.patch("/itens/:id", pedidosController.updateItens());

module.exports = routes;
