const express = require("express");
const routes = express.Router();
const multer = require("multer");
const {verifyToken, isEmpresa} = require("../auth/middlewares/authMiddleware");

const storage = multer.memoryStorage();


const upload = multer({ 
    storage,
    dest: "uploads/"
})

const OrçamentosController = require("./orcamentos.controller");
const orcamentosController = new OrçamentosController();

// IMPORTANTE: não chame o método, passe a referência
routes.post("/", upload.single("file"),verifyToken,isEmpresa, orcamentosController.register());
routes.patch("/:id", orcamentosController.updateStatus());
routes.patch("/empresa/:id", orcamentosController.statusUpdateEmpresa());
routes.patch("/compras/:id", orcamentosController.mudarPreçoCompras());
routes.get("/", orcamentosController.getAll());
routes.get("/empresa/:id_empresa", orcamentosController.getAllByEmpresa());
routes.get("/:id", orcamentosController.getById());


module.exports = routes;
