const Orçamento = require("./orcamentos.repository");

class OrçamentosController {
    #orcamentos;

    constructor(orcamentosRepository = new Orçamento()) {
        this.#orcamentos = orcamentosRepository;
    }

    register() {
        return async (req, res) => {
            try {
                const data = JSON.parse(req.body.data); // ← IMPORTANTE
                const file = req.file;
                const{ trueId: userId } = req.user;
                data.userId = userId;


                // Adiciona o ID do usuário aos dados que serão salvos
                const response = await this.#orcamentos.register({ ...data, userId }, file);

                if (response.error)
                    return res.status(response.code).json(response);

                return res.status(200).json(response);

            } catch (error) {
                console.error(error);
                return res.status(error.code || 500).json(error);
            }
        };
    }

    getAll(){
        return async (req, res) => {
            try {
                const response = await this.#orcamentos.getAll();
                return res.status(200).json(response);
            } catch (error) {
                console.error(error);
                return res.status(error.code || 500).json(error);
            }
        };
    }

    getAllByEmpresa(){
        return async (req, res) => {
            try {
                const id_empresa = req.params.id_empresa;
                const response = await this.#orcamentos.getAllByEmpresa(id_empresa);
                return res.status(200).json(response);
                } catch (error) {
                console.error(error);
                return res.status(error.code || 500).json(error);
            }
        };
    }

    getById(){
        return async (req, res) => {
            try {
                const id = req.params.id;
                const response = await this.#orcamentos.getById(id);
                return res.status(200).json(response);
                } catch (error) {
                console.error(error);
                return res.status(error.code || 500).json(error);
            }
    }
    }

    updateStatus(){
        return async (req, res) => {
            try {
                const id = req.params.id;
                const data = req.body;
                const response = await this.#orcamentos.updateStatus(data, id);
                return res.status(200).json(response);
            } catch (error) {
                console.error(error);
                return res.status(error.code || 500).json(error);
            }
        }
}
    statusUpdateEmpresa(){
        return async (req, res) => {
            try {
                const id = req.params.id;
                const data = req.body;
                const response = await this.#orcamentos.statusUpdateEmpresa(data, id);
                return res.status(200).json(response);
            } catch (error) {
                console.error(error);
                return res.status(error.code || 500).json(error);
            }
        }

    
}

mudarPreçoCompras(){
    return async (req, res) => {
        try{
            const id = req.params.id;
            const data = req.body;
            const response = await this.#orcamentos.mudarPreçoCompras(data, id);
            return res.status(200).json(response);
        }catch(error){
            console.error(error);
            return res.status(error.code || 500).json(error);
        }
    }
}
}

module.exports = OrçamentosController;
