const express = require("express");
const routes = express.Router();
const multer = require("multer");

const storage = multer.memoryStorage();


const upload = multer({ 
    storage,
    dest: "uploads/"
})

const OperariosController = require("./operarios.controller");
const operariosController = new OperariosController();

routes.get("/hoje/empresa/:id", operariosController.getOperariosDeHojePorEmpresa());
routes.get("/data", operariosController.getOperariosPorData());
routes.post("/",   upload.fields([
    { name: "foto_documento", maxCount: 1 },
    { name: "foto_cursos", maxCount: 1 },
    { name: "foto_epi", maxCount: 1 },
  ]), operariosController.register());

routes.get("/", operariosController.getOperarios());
routes.get("/:id", operariosController.getUmOperario());
routes.delete("/:id", operariosController.delete());
routes.patch("/", operariosController.update());


module.exports = routes;