const Operarios = require("./operarios.repository");

class OperariosController {
  #operarios;

  constructor(operariosRepository = new Operarios()) {
    this.#operarios = operariosRepository;
  }

  /**
   * Cadastra um operário
   */
  register() {
    return async (req, res) => {
      try {
        const data = req.body;
        const files = req.files;
        const response = await this.#operarios.register(data, files);

        if (response.error) return res.status(response.code).json(response);
        return res.status(response.code).json(response);
      } catch (error) {
        console.error(error);
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Lista todos os operários
   */
  getOperarios() {
    return async (req, res) => {
      try {
        const response = await this.#operarios.getOperarios();

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        console.error(error);
        return res.status(error.code || 500).json(error);
      }
    };
  }

  getOperariosDeHojePorEmpresa() {
    return async (req, res) => {
      try {
        const id = req.params.id;

        const response = await this.#operarios.getOperariosDeHojePorEmpresa(id);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        console.error(error);
        return res.status(error.code || 500).json(error);
      }
    };
  }

  getOperariosPorData() {
    return async (req, res) => {
      try {

        const data = req.query.data

        const response = await this.#operarios.getOperariosPorData(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        console.error(error);
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Busca um único operário
   */
  getUmOperario() {
    return async (req, res) => {
      try {
        const id = req.params.id;

        const response = await this.#operarios.getUmOperario(id);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        console.error(error);
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Atualiza um operário
   */
  update() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#operarios.update(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(response.code).json(response);
      } catch (error) {
        console.error(error);
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Remove um operário
   */
  delete() {
    return async (req, res) => {
      try {
        const id = req.params.id;
        const response = await this.#operarios.delete(id);

        if (response.error) return res.status(response.code).json(response);
        return res.status(response.code).json(response);
      } catch (error) {
        console.error(error);
        return res.status(error.code || 500).json(error);
      }
    };
  }
}

module.exports = OperariosController;
