const express = require("express");
const routes = express.Router();
const multer = require("multer");

// Configura para salvar na memória RAM temporariamente (necessário para o S3)
const storage = multer.memoryStorage();

const upload = multer({ 
    storage: storage,
    // Removi o 'dest' pois se usar 'dest', o 'req.file.buffer' fica vazio
    limits: { fileSize: 5 * 1024 * 1024 } // Opcional: Limita a 5MB por segurança
});

const NotasController = require("./notas.controller");
const notasController = new NotasController();

// CORREÇÃO CRÍTICA: 
// Mudamos de "file" para "arquivo" para bater com o Frontend
routes.post("/", upload.single("arquivo"), notasController.entrada_nota());

routes.get("/:id_orcamento", notasController.buscarNotas());

module.exports = routes;