const { PutObjectCommand, S3Client } = require("@aws-sdk/client-s3");

class NotasRepository {
    // Certifique-se que o caminho para o seu DB está correto
    #db = require("../../config/db"); 
    #region = process.env.AWS_S3_REGION;

    constructor() {
        this.s3Client = new S3Client({
            region: process.env.AWS_S3_REGION,
            credentials: {
                accessKeyId: process.env.AWS_ACCESS_KEY_ID,
                secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY,
            },
        });
        this.S3_BUCKET = process.env.AWS_S3_BUCKET
    }

    entrada_nota(data, file) {
        return new Promise(async (resolve, reject) => {
            try {
                let url = "";

                // Função interna para Upload
                const uploadToS3 = async (file) => {
                    if (!file) return "";

                    // 1. CRIA NOME ÚNICO (Timestamp + Nome original limpo de espaços)
                    const uniqueFileName = `${Date.now()}_${file.originalname.replace(/\s+/g, '-')}`;
                    
                    // URL pública final
                    const pdfUrl = `https://${this.S3_BUCKET}.s3.${this.#region}.amazonaws.com/${uniqueFileName}`;

                    const command = new PutObjectCommand({
                        Bucket: this.S3_BUCKET,
                        Key: uniqueFileName, // Usa o nome único
                        Body: file.buffer,
                        ContentType: file.mimetype,
                        // ACL: 'public-read' // Descomente se seu bucket permitir ACLs públicas
                    });

                    await this.s3Client.send(command);

                    return pdfUrl;
                };

                // Executa upload
                url = await uploadToS3(file);

                // 2. QUERY ATUALIZADA
                // Agora salvamos id_orcamento e competencia para vincular ao mês correto
                const sql = `
                    INSERT INTO notas (id_orcamento, competencia, numero_nota, valor, url, criado_em)
                    VALUES (?, ?, ?, ?, ?, NOW())
                `;

                // Array de valores na ordem exata da query
                const values = [
                    data.id_orcamento, 
                    data.competencia, 
                    data.numero_nota, 
                    data.valor, // Mudamos de 'preco' para 'valor' para padronizar
                    url
                ];

                this.#db.query(sql, values, (error, response) => {
                    if (error) {
                        console.error("Erro ao cadastrar nota no Banco:", error);
                        return reject({ error: true, message: "Erro de banco de dados", code: 500 });
                    }
                    
                    return resolve({ 
                        success: true, 
                        message: "Nota cadastrada com sucesso!", 
                        code: 201,
                        insertId: response.insertId
                    });
                });

            } catch (error) {
                console.error("Erro geral no Repository:", error);
                return reject({ error: true, message: "Erro ao processar cadastro da nota", code: 500 });
            }
        })
    }

    buscarPorOrcamento(id_orcamento) {
    return new Promise((resolve, reject) => {
        // Busca apenas as colunas necessárias para validar a timeline
        const sql = `SELECT id, competencia, url, numero_nota FROM notas WHERE id_orcamento = ?`;
        
        this.#db.query(sql, [id_orcamento], (error, results) => {
            if (error) {
                console.error("Erro ao buscar notas:", error);
                return reject({ error: true, code: 500 });
            }
            return resolve(results);
        });
    });
    }

    


}

module.exports = NotasRepository;