const Notas = require("./notas.repository"); 

class NotasController {
    #notas;

    constructor(notasRepository = new Notas()) {
        this.#notas = notasRepository;
    }

    entrada_nota() {
        return async (req, res) => {
            try {
                // FormData envia tudo como string. Conversão necessária:
                const data = {
                    ...req.body,
                    id_orcamento: Number(req.body.id_orcamento),
                    valor: req.body.valor ? Number(req.body.valor.replace(',', '.')) : 0
                };

                const file = req.file;

                // Validação rápida
                if (!file) {
                    return res.status(400).json({ error: true, message: "Arquivo da nota é obrigatório." });
                }

                const response = await this.#notas.entrada_nota(data, file);

                if (response.error) return res.status(response.code).json(response);

                return res.status(response.code).json(response);
            } catch (error) {
                console.error("Erro no controller:", error);
                return res.status(error.code || 500).json({
                    error: true,
                    message: "Erro interno no servidor"
                });
            }
        }
    }

    buscarNotas() {
    return async (req, res) => {
        try {
            const { id_orcamento } = req.params;
            const notas = await this.#notas.buscarPorOrcamento(id_orcamento);
            return res.json(notas);
        } catch (error) {
            return res.status(500).json({ error: "Erro ao buscar notas" });
        }
    }
    }

    
} 


module.exports = NotasController;