const express = require("express");
const routes = express.Router();
const auth = require("../../config/auth/auth.js");


const IndicacoesController = require("./indicacoes.controller");
const indicacoesController = new IndicacoesController();

routes.get("/aprovados", indicacoesController.getIndicacoesAprovado());

routes.post("/", indicacoesController.register());
routes.get("/", indicacoesController.getIndicacoes());
routes.get("/:id", indicacoesController.getUmaIndicacao());
routes.delete("/:id", indicacoesController.delete());
routes.patch("/", indicacoesController.update());


module.exports = routes;