

class IndicacoesRepository {
  #db = require("../../config/db");

  constructor() {}

  /**
   * Cadastra uma indicação
   * @param {*} data 
   * @returns 
   */
  register(data) {
    return new Promise(async (resolve, reject) => {
      try {
        

        this.#db.query(
          `INSERT INTO indicacoes 
            (quem_indicou,  nome, atividade, celular, email, status)
           VALUES (?, ?, ?, ?, ?, "Pendente")`,
          [
            data.quem_indicou,
            data.nome,
            data.atividade || "",
            data.celular || "",
            data.email || "",
          ],
          async (error, response) => {
            if (error) {
              console.error(error);
              return reject({ error: true, message: "Erro ao cadastrar indicação", code: 500 });
            }
            return resolve({ success: true, message: "Indicação cadastrada com sucesso!", code: 200 });
          }
        );

      } catch (err) {
        console.error("Erro ao cadastrar indicação ", err);
        return reject({ error: true, message: "Erro ao cadastrar indicação", code: 500 });
      }
    });
  }

  /**
   * Lista todas as indicações
   */
  getIndicacoes() {
    return new Promise((resolve, reject) => {
      try {
        this.#db.query(
          `SELECT id, quem_indicou, nome, atividade, celular, email, status
           FROM indicacoes`,
          [],
          (error, indicacoes) => {
            if (error) {
              console.error("Erro ao buscar indicações ", error);
              return reject({ error: true, message: "Erro ao buscar indicações", code: 500 });
            }
            return resolve(indicacoes);
          }
        );
      } catch (error) {
        console.error("Erro ao buscar indicações ", error);
        return reject({ error: true, message: "Erro ao buscar indicações", code: 500 });
      }
    });
  }

    getIndicacoesAprovado() {
    return new Promise((resolve, reject) => {
      try {
        this.#db.query(
          `SELECT id, quem_indicou, nome, atividade, celular, email, status
           FROM indicacoes WHERE status like "Aprovado"`,
          [],
          (error, indicacoes) => {
            if (error) {
              console.error("Erro ao buscar indicações ", error);
              return reject({ error: true, message: "Erro ao buscar indicações", code: 500 });
            }
            return resolve(indicacoes);
          }
        );
      } catch (error) {
        console.error("Erro ao buscar indicações ", error);
        return reject({ error: true, message: "Erro ao buscar indicações", code: 500 });
      }
    });
  }


  /**
   * Busca uma indicação pelo ID
   * @param {*} id 
   * @returns 
   */
  getUmaIndicacao(id) {
    return new Promise((resolve, reject) => {
      try {
        this.#db.query(
          `SELECT id, quem_indicou, nome, atividade, celular, email, status
           FROM indicacoes
           WHERE id = ?`,
          [id],
          (error, results) => {
            if (error) {
              console.error("Erro ao buscar indicação ", error);
              return reject({ error: true, message: "Erro ao buscar indicação", code: 500 });
            }

            if (results.length === 0) {
              return reject({ error: true, message: "Indicação não encontrada", code: 404 });
            }

            return resolve(results[0]);
          }
        );
      } catch (error) {
        console.error("Erro ao buscar indicação ", error);
        return reject({ error: true, message: "Erro ao buscar indicação", code: 500 });
      }
    });
  }


  /**
   * Deleta uma indicação
   * @param {*} id 
   * @returns 
   */
  delete(id) {
    return new Promise((resolve, reject) => {
      this.#db.query(
        "DELETE FROM indicacoes WHERE id = ?",
        [id],
        (error) => {
          if (error) {
            console.error("Erro ao deletar indicação ", error);
            return reject({ error: true, message: "Erro ao deletar indicação", code: 409 });
          }
          return resolve({ success: true, message: "Indicação deletada com sucesso!", code: 200 });
        }
      );
    });
  }

  /**
   * Atualiza uma indicação
   * @param {*} data 
   * @returns 
   */
  update(data) {
    return new Promise(async (resolve, reject) => {
      try {
        const fields = [];
        const values = [];

        if (data.quem_indicou) { fields.push("quem_indicou = ?"); values.push(data.quem_indicou); }
        if (data.nome) { fields.push("nome = ?"); values.push(data.nome); }
        if (data.atividade) { fields.push("atividade = ?"); values.push(data.atividade); }
        if (data.celular) { fields.push("celular = ?"); values.push(data.celular); }
        if (data.email) { fields.push("email = ?"); values.push(data.email); }
        if (data.status) { fields.push("status = ?"); values.push(data.status); }

        if (fields.length === 0) {
          return reject({ error: true, message: "Nenhum dado para atualizar", code: 422 });
        }

        values.push(data.id);

        const query = `
          UPDATE indicacoes
          SET ${fields.join(", ")}
          WHERE id = ?
        `;

        this.#db.query(query, values, (error, response) => {
          if (error) {
            console.error(error);
            return reject({ error: true, message: "Erro ao atualizar indicação", code: 500 });
          }

          if (response.affectedRows === 0) {
            return reject({ error: true, message: "Indicação não encontrada", code: 404 });
          }

          return resolve({ success: true, message: "Indicação atualizada com sucesso!", code: 200 });
        });

      } catch (error) {
        console.error(error);
        return reject({ error: true, message: "Erro ao atualizar indicação", code: 500 });
      }
    });
  }
}

module.exports = IndicacoesRepository;
