const Indicacao = require("./indicacoes.repository");

class IndicacoesController {
  #indicacoes;

  constructor(indicacoesRepository = new Indicacao()) {
    this.#indicacoes = indicacoesRepository;
  }

  /**
   * Registra uma indicação
   */
  register() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#indicacoes.register(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(response.code).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Lista todas as indicações
   */
  getIndicacoes() {
    return async (req, res) => {
      try {
        const response = await this.#indicacoes.getIndicacoes();
        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  
  /**
   * Lista todas as indicações
   */
  getIndicacoesAprovado() {
    return async (req, res) => {
      try {
        const response = await this.#indicacoes.getIndicacoesAprovado();
        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Busca uma indicação por ID
   */
  getUmaIndicacao() {
    return async (req, res) => {
      try {
        const id = req.params.id;
        const response = await this.#indicacoes.getUmaIndicacao(id);

        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Deleta uma indicação
   */
  delete() {
    return async (req, res) => {
      try {
        const id = req.params.id;

        const response = await this.#indicacoes.delete(id);
        if (response.error) return res.status(response.code).json(response);

        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Atualiza uma indicação
   */
  update() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#indicacoes.update(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }
}

module.exports = IndicacoesController;
