const express = require("express");
const routes = express.Router();
const multer = require("multer");

const storage = multer.memoryStorage();


const upload = multer({ 
    storage,
    dest: "uploads/"
})


const FornecedoresController = require("./fornecedores.controller");
const fornecedoresController = new FornecedoresController();

routes.post("/formulario", upload.single("file"), fornecedoresController.enviarFormulario())

routes.post("/", fornecedoresController.register());
routes.get("/", fornecedoresController.getFornecedores());
routes.get("/:id", fornecedoresController.getUmFornecedor());
routes.delete("/:id", fornecedoresController.delete());
routes.patch("/", upload.single("file"), fornecedoresController.update());


module.exports = routes;