const Fornecedores = require("./fornecedores.repository");


class FornecedoresController {
  #fornecedores;

    constructor(fornecedoresRepository = new Fornecedores()) {
    this.#fornecedores = fornecedoresRepository;
  }


  /**
   * Realiza o login de um usuário
   * @returns mensagem referente ao resultado obtido
   */
  login() {
    return async (req, res) => {
      try {
        const data = req.body;
        const ip = req.headers["x-forwarded-for"] || req.connection.remoteAddress;

        const response = await this.#fornecedores.login(data, ip);
        if (response.error) return res.status(response.code).json(response);

        return res.status(200).json(response);
      } catch (error) {
        console.error(error);
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Registra um usuário
   */
  register() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#fornecedores.register(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(response.code).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  enviarFormulario() {
    return async (req, res) => {
      try {
        const data = req.body;
        const file = req.file;
        const response = await this.#fornecedores.enviarFormulario(data, file);

        if (response.error) return res.status(response.code).json(response);
        return res.status(response.code).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Envia um email para recuperação de senha
   */
  recover() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#fornecedores.recover(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Realiza o logout do usuário
   */
  logout() {
    return async (req, res) => {
      try {
        const user = req.user
        const response = await this.#fornecedores.logout(user);

        return res.status(response.code).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Lista todos os usuários
   */
  getFornecedores() {
    return async (req, res) => {
      try {
        const response = await this.#fornecedores.getFornecedores();
        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }


  getUmFornecedor() {
    return async (req, res) => {
      try {

        const id = req.params.id;

        const response = await this.#fornecedores.getUmFornecedor(id);

        return res.status(200).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Deleta um usuário
   */
  delete() {
    return async (req, res) => {
      try {
        const id = req.params.id;
        console.log(id);
        
        const response = await this.#fornecedores.delete(id);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Atualiza os dados de um usuário
   */
  update() {
    return async (req, res) => {
      try {
        const data = req.body;
        const file = req.file;
        const response = await this.#fornecedores.update(data, file);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

}
module.exports = FornecedoresController;

