const express = require("express");
const routes = express.Router();
const multer = require("multer");

const storage = multer.memoryStorage();


const upload = multer({ 
    storage,
    dest: "uploads/"
})

const FinanceirosController = require("./financeiros.controller");
const financeirosController = new FinanceirosController();

routes.post("/mensagens", financeirosController.enviarMensagemFinanceiro());

routes.post("/", financeirosController.registerFinanceiro());
routes.get("/", financeirosController.getFinanceiros());
routes.get("/celulares", financeirosController.getCelularesDosFinanceiros());
routes.get("/:id", financeirosController.getUmFinanceiro());
routes.delete("/:id", financeirosController.delete());
routes.patch("/", financeirosController.update());


module.exports = routes;