const Financeiro = require("./financeiros.repository");


class FinanceirosController {
  #financeiros;

    constructor(financeirosRepository = new Financeiro()) {
    this.#financeiros = financeirosRepository;
  }


  /**
   * Realiza o login de um usuário
   * @returns mensagem referente ao resultado obtido
   */
  login() {
    return async (req, res) => {
      try {
        const data = req.body;
        const ip = req.headers["x-forwarded-for"] || req.connection.remoteAddress;

        const response = await this.#financeiros.login(data, ip);
        if (response.error) return res.status(response.code).json(response);

        return res.status(200).json(response);
      } catch (error) {
        console.error(error);
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Registra um usuário
   */
  registerFinanceiro() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#financeiros.registerFinanceiro(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(response.code).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  registerEmpresa() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#financeiros.registerEmpresa(data);
        if (response.error) return res.status(response.code).json(response);
        return res.status(response.code).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }


  updateEmpresa(){
    return async (req, res) => {
      try {
        const data = req.body;
        const id_empresa = req.params.id_empresa;
        const response = await this.#financeiros.updateEmpresa(data, id_empresa);
        if (response.error) return res.status(response.code).json(response);
        return res.status(response.code).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }
  
  deleteEmpresa(){
    return async (req, res) => {
      try {
        const id_empresa = req.params.id_empresa;
        const response = await this.#financeiros.deleteEmpresa(id_empresa);
        if (response.error) return res.status(response.code).json(response);
        return res.status(response.code).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }
  
  getEmpresas(){
    return async (req, res) => {
      try {
        const response = await this.#financeiros.getEmpresas();
        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  getStatusEmpresa(){
    return async (req, res) => {
      try {
        const id_empresa = req.params.id_empresa;
        const response = await this.#financeiros.getStatusEmpresa(id_empresa);
        if(response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      }catch(error){
        return res.status(error.code || 500).json(error);
      }
    }
      }



  /**
   * Envia um email para recuperação de senha
   */
  recover() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#financeiros.recover(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Realiza o logout do usuário
   */
  logout() {
    return async (req, res) => {
      try {
        const user = req.user
        const response = await this.#financeiros.logout(user);

        return res.status(response.code).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Lista todos os usuários
   */
  getFinanceiros() {
    return async (req, res) => {
      try {
        const response = await this.#financeiros.getFinanceiros();
        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }


  getUmFinanceiro() {
    return async (req, res) => {
      try {

        const id = req.params.id;

        const response = await this.#financeiros.getUmFinanceiro(id);

        return res.status(200).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }


    getCelularesDosFinanceiros() {
    return async (req, res) => {
      try {

        const response = await this.#financeiros.getCelularesDosFinanceiros();

        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  enviarMensagemFinanceiro() {
    return async (req, res) => {
      try {

        const data = req.body

        const response = await this.#financeiros.enviarMensagemFinanceiro(data);

        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Deleta um usuário
   */
  delete() {
    return async (req, res) => {
      try {
        const id = req.params.id;
        console.log(id);
        
        const response = await this.#financeiros.delete(id);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Atualiza os dados de um usuário
   */
  update() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#financeiros.update(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  enviarMensagemParaResponsavel() {
    return async (req, res) => {
      try {
        const data = req.body;

       const response = await this.#financeiros.enviarMensagemParaResponsavel(data);

        return res.status(response.code).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

}
module.exports = FinanceirosController;