const express = require("express");
const routes = express.Router();
const multer = require("multer");

const storage = multer.memoryStorage();


const upload = multer({ 
    storage,
    dest: "uploads/"
})

const EngenheirosController = require("./engenheiros.controller");
const engenheirosController = new EngenheirosController();

routes.post("/inserirVideo", upload.single("video"), engenheirosController.inserirVideo());

routes.post("/", engenheirosController.register());
routes.get("/", engenheirosController.getEngenheiros());
routes.get("/:id", engenheirosController.getUmEngenheiro());
routes.delete("/:id", engenheirosController.delete());
routes.patch("/", engenheirosController.update());


module.exports = routes;