const { genereteToken } = require("../../config/auth/jwt");
const nodemailer = require("nodemailer");
const path = require("path");
const https = require("https");
const fs = require("fs");
const bcrypt = require('bcrypt');
const { validarCNPJ } = require("../../util/validarCNPJ");
const { validarCPF } = require("../../util/validarCPF");
const { S3Client, PutObjectCommand } = require("@aws-sdk/client-s3");
const sharp = require("sharp");
const { sendMedia } = require("../../util/gzappy");

class EngenheirosRepository {
  #db = require("../../config/db");
  #region = process.env.AWS_S3_REGION;

  constructor() {

    this.s3Client = new S3Client({
      region: process.env.AWS_S3_REGION,
      credentials: {
        accessKeyId: process.env.AWS_ACCESS_KEY_ID,
        secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY,
      },
    });
    this.S3_BUCKET = process.env.AWS_S3_BUCKET
  }

  /**
   * Cadastra um engenheiro
   * @param {*} data 
   * @returns 
   */
  register(data) {
    return new Promise((resolve, reject) => {
      try {
        this.#db.query(
          `INSERT INTO engenheiros (nome, atividade, celular)
           VALUES (?, ?, ?)`,
          [
            data.nome,
            data.atividade || "",
            data.celular || ""
          ],
          (error, response) => {
            if (error) {
              console.error(error);
              return reject({ error: true, message: "Erro ao cadastrar engenheiro", code: 500 });
            }
            return resolve({ success: true, message: "Engenheiro cadastrado com sucesso!", code: 200 });
          }
        );
      } catch (err) {
        console.error("Erro ao cadastrar engenheiro ", err);
        return reject({ error: true, message: "Erro ao cadastrar engenheiro", code: 500 });
      }
    });
  }

  /**
   * Lista todos engenheiros
   */
  getEngenheiros() {
    return new Promise((resolve, reject) => {
      try {
        this.#db.query(
          `SELECT id, nome, atividade, celular FROM engenheiros`,
          [],
          (error, results) => {
            if (error) {
              console.error("Erro ao buscar engenheiros ", error);
              return reject({ error: true, message: "Erro ao buscar engenheiros", code: 500 });
            }
            return resolve(results);
          }
        );
      } catch (error) {
        console.error("Erro ao buscar engenheiros ", error);
        return reject({ error: true, message: "Erro ao buscar engenheiros", code: 500 });
      }
    });
  }

  /**
   * Busca apenas um engenheiro pelo id
   */
  getUmEngenheiro(id) {
    return new Promise((resolve, reject) => {
      try {
        this.#db.query(
          `SELECT id, nome, atividade, celular
           FROM engenheiros
           WHERE id = ?`,
          [id],
          (error, results) => {
            if (error) {
              console.error("Erro ao buscar engenheiro ", error);
              return reject({ error: true, message: "Erro ao buscar engenheiro", code: 500 });
            }

            if (results.length === 0) {
              return reject({ error: true, message: "Engenheiro não encontrado", code: 404 });
            }

            return resolve(results[0]);
          }
        );
      } catch (error) {
        console.error("Erro ao buscar engenheiro ", error);
        return reject({ error: true, message: "Erro ao buscar engenheiro", code: 500 });
      }
    });
  }

  /**
   * Deleta um engenheiro pelo id
   */
  delete(id) {
    return new Promise((resolve, reject) => {
      this.#db.query(
        "DELETE FROM engenheiros WHERE id = ?",
        [id],
        (error, response) => {
          if (error) {
            console.error("Erro ao deletar engenheiro ", error);
            return reject({ error: true, message: "Erro ao deletar engenheiro", code: 500 });
          }

          if (response.affectedRows === 0) {
            return reject({ error: true, message: "Engenheiro não encontrado", code: 404 });
          }

          return resolve({ success: true, message: "Engenheiro deletado com sucesso!", code: 200 });
        }
      );
    });
  }

  /**
   * Atualiza dados de um engenheiro
   */
  update(data) {
    return new Promise((resolve, reject) => {
      try {
        const fields = [];
        const values = [];

        if (data.nome) { fields.push("nome = ?"); values.push(data.nome); }
        if (data.atividade) { fields.push("atividade = ?"); values.push(data.atividade); }
        if (data.celular) { fields.push("celular = ?"); values.push(data.celular); }

        if (fields.length === 0) {
          return reject({ error: true, message: "Nenhum dado para atualizar", code: 422 });
        }

        values.push(data.id);

        const query = `
          UPDATE engenheiros
          SET ${fields.join(", ")}
          WHERE id = ?
        `;

        this.#db.query(query, values, (error, response) => {
          if (error) {
            console.error("Erro ao atualizar engenheiro", error);
            return reject({ error: true, message: "Erro ao atualizar engenheiro", code: 500 });
          }

          if (response.affectedRows === 0) {
            return reject({ error: true, message: "Engenheiro não encontrado", code: 404 });
          }

          return resolve({ success: true, message: "Engenheiro atualizado com sucesso!", code: 200 });
        });

      } catch (error) {
        console.error(error);
        return reject({ error: true, message: "Erro ao atualizar engenheiro", code: 500 });
      }
    });
  }

  inserirVideo(data, file) {
    return new Promise(async (resolve, reject) => {
      try {

        const engenheiro = await this.getUmEngenheiro(data.id);

        console.log("engenheiro", engenheiro);
        

        let imageUrl = null;
        if (file) {

          imageUrl = `https://${this.S3_BUCKET}.s3.${this.#region}.amazonaws.com/${file?.originalname}`;

          const command = new PutObjectCommand({
            Bucket: this.S3_BUCKET,
            Key: file.originalname,
            Body: file.buffer,
            ContentType: file.mimetype
          });

          console.log(await this.s3Client.send(command))
        }
        

        // this.#db.query(
        //   `INSERT INTO video (nome, atividade, celular)
        //    VALUES (?, ?, ?)`,
        //   [
        //     data.nome,
        //     data.atividade || "",
        //     data.celular || ""
        //   ],
        //   (error, response) => {
        //     if (error) {
        //       console.error(error);
        //       return reject({ error: true, message: "Erro ao cadastrar engenheiro", code: 500 });
        //     }
        //     return resolve({ success: true, message: "Engenheiro cadastrado com sucesso!", code: 200 });
        //   }
        // );

        // return resolve({ code: 200, video_url: imageUrl });

        await sendMedia("Vídeo do engenheiro", "55"+engenheiro.celular, imageUrl);

        return resolve({ success: true, message: "Vídeo enviado com sucesso!", code: 200 });

      } catch (err) {
        console.error("Erro ao cadastrar engenheiro ", err);
        return reject({ error: true, message: "Erro ao cadastrar engenheiro", code: 500 });
      }
    });
  }

}

module.exports = EngenheirosRepository;

