const Engenheiro = require("./engenheiros.repository");


class EngenheirosController {
  #engenheiros;
    constructor(engenheirosRepository = new Engenheiro()) {
    this.#engenheiros = engenheirosRepository;
  }



  /**
   * Registra um usuário
   */
  register() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#engenheiros.register(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(response.code).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Lista todos os usuários
   */
  getEngenheiros() {
    return async (req, res) => {
      try {
        const response = await this.#engenheiros.getEngenheiros();
        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }


  getUmEngenheiro() {
    return async (req, res) => {
      try {

        const id = req.params.id;

        const response = await this.#engenheiros.getUmEngenheiro(id);

        return res.status(200).json(response);

      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Deleta um usuário
   */
  delete() {
    return async (req, res) => {
      try {
        const id = req.params.id;
        console.log(id);
        
        const response = await this.#engenheiros.delete(id);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

  /**
   * Atualiza os dados de um usuário
   */
  update() {
    return async (req, res) => {
      try {
        const data = req.body;
        const response = await this.#engenheiros.update(data);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

    inserirVideo() {
    return async (req, res) => {
      try {
        const data = req.body;
        const file = req.file;
        const response = await this.#engenheiros.inserirVideo(data, file);

        if (response.error) return res.status(response.code).json(response);
        return res.status(200).json(response);
      } catch (error) {
        return res.status(error.code || 500).json(error);
      }
    };
  }

}
module.exports = EngenheirosController;

