const { genereteToken } = require("../../config/auth/jwt");
const nodemailer = require("nodemailer");
const path = require("path");
const https = require("https");
const fs = require("fs");
const bcrypt = require('bcrypt');
const { validarCNPJ } = require("../../util/validarCNPJ");
const { validarCPF } = require("../../util/validarCPF");
const { S3Client, PutObjectCommand } = require("@aws-sdk/client-s3");
const sharp = require("sharp");
const { sendMedia } = require("../../util/gzappy");



class CompradoresRepository {
    #db = require("../../config/db");
    #region = process.env.AWS_S3_REGION;

  constructor() {

    this.s3Client = new S3Client({
      region: process.env.AWS_S3_REGION,
      credentials: {
        accessKeyId: process.env.AWS_ACCESS_KEY_ID,
        secretAccessKey: process.env.AWS_SECRET_ACCESS_KEY,
      },
    });
    this.S3_BUCKET = process.env.AWS_S3_BUCKET
  }

 register(data) {
  return new Promise(async (resolve, reject) => {
    try {
      // 1. Validar CPF/CNPJ
      const resultado =
        data.cnpj_cpf.length === 11 ? validarCPF(data.cnpj_cpf) :
        data.cnpj_cpf.length === 14 ? validarCNPJ(data.cnpj_cpf) : null;

      if (!resultado) {
        return reject({ error: true, message: "CPF ou CNPJ inválido", code: 400 });
      }

      // 2. Criptografar senha
      const hashedPassword = await bcrypt.hash(data.senha, 10);

      // 3. Inserir comprador
      this.#db.query(
        `
        INSERT INTO compradores 
        (nome, cnpj_cpf, senha, telefone)
        VALUES (?, ?, ?, ?)
        `,
        [
          data.nome,
          data.cnpj_cpf,
          hashedPassword,
          data.telefone || ""
        ],
        (error, response) => {
          if (error) {
            console.error(error);
            return reject({
              error: true,
              message: "Erro ao cadastrar comprador",
              code: 500
            });
          }

          const id_comprador = response.insertId;

          // 4. Criar usuário atrelado ao comprador
          this.#db.query(
            `
            INSERT INTO users (nome, senha, role, cnpj_cpf)
            VALUES (?, ?, 'comprador', ?)
            `,
            [data.nome, hashedPassword, data.cnpj_cpf],
            (error, userResponse) => {
              if (error) {
                console.error(error);
                return reject({
                  error: true,
                  message: "Erro ao criar usuário",
                  code: 500
                });
              }

              const id_user = userResponse.insertId;

              // 5. Atualizar comprador com id_user
              this.#db.query(
                `
                UPDATE compradores
                SET id_user = ?
                WHERE id = ?
                `,
                [id_user, id_comprador],
                (error) => {
                  if (error) {
                    console.error(error);
                    return reject({
                      error: true,
                      message: "Erro ao vincular usuário ao comprador",
                      code: 500
                    });
                  }

                  return resolve({
                    error: false,
                    message: "Comprador cadastrado com sucesso",
                    code: 201
                  });
                }
              );
            }
          );
        }
      );

    } catch (error) {
      console.error(error);
      return reject({
        error: true,
        message: "Erro interno ao cadastrar comprador",
        code: 500
      });
    }
  });
}

getCompradores() {
  return new Promise((resolve, reject) => {
    this.#db.query(
      `
      SELECT id, nome, cnpj_cpf, telefone
      FROM compradores
      `,
      (error, results) => {
        if (error) {
          console.error(error);
          return reject({
            error: true,
            message: "Erro ao buscar compradores",
            code: 500
          });
        }

        return resolve({
          error: false,
          code: 200,
          data: results
        });
      }
    );
  });
}

getCompradorById(compradoresId) {
    return new Promise((resolve, reject) => {
      this.#db.query(
        `
        SELECT id, nome, cnpj_cpf, telefone
        FROM compradores
        WHERE id = ?
        `,
        [compradoresId],
        (error, results) => {
          if (error) { 
            console.error(error);
            return reject({
                error: true,
                message: "Erro ao buscar comprador",
                code: 500
            });
          }
            if (results.length === 0) {
                return resolve(null);
            }
            return resolve(results[0]);
        }
      );
    });
  }


  deleteComprador(compradoresId) {
    return new Promise((resolve, reject)=>{
      this.#db.query(
        `DELETE FROM compradores WHERE id = ?`,
        [compradoresId],
        (error, results) => {
          if (error) {
            console.error(error);
            return reject({
              error: true,
              message: "Erro ao deletar comprador",
              code: 500
            })
          }
          this.#db.query(`
            DELETE FROM users WHERE trueId = ?`,
            [compradoresId],
            (error, results)=>{
              if(error){
                console.error(error);
                return reject({
                  error: true,
                  message: "Erro ao deletar usuário",
                  code: 500})
              }
              return resolve({
                sucess: true,
                message: "Comprador deletado com sucesso",
                code: 200
              })
            })
        }
      )
    })
  }







}


module.exports = CompradoresRepository;