const Comprador = require("./compradores.repository");

class CompradoresController {
  #compradores;
    constructor(compradoresRepository = new Comprador()) {
    this.#compradores = compradoresRepository;
  }

  register() {
    return async (req, res) => {
        try {
            const data = req.body;
            const response = await this.#compradores.register(data);
            if (response.error) return res.status(response.code).json(response);
            return res.status(response.code).json(response);
        } catch (error) {
            return res.status(error.code || 500).json(error);
        }
    };
    }

    getCompradores() {
  return async (req, res) => {
    try {
      const response = await this.#compradores.getCompradores();

      if (response.error) {
        return res.status(response.code).json(response);
      }

      return res.status(200).json(response);

    } catch (error) {
      return res.status(error.code || 500).json(error);
    }
  };
}



    getCompradorById() {
      return async (req, res) => {
          try {
              const { compradoresId } = req.params;
              const response = await this.#compradores.getCompradorById(compradoresId);
              if (response.error) return res.status(response.code).json(response);
              return res.status(200).json(response);
          } catch (error) {
              return res.status(error.code || 500).json(error);
          }
      };
      }

    
    deleteComprador(){
      return async (req, res) => {
        try{

          const { compradoresId } = req.params;
          const response = await this.#compradores.deleteComprador(compradoresId);
          if (response.error) return res.status(response.code).json(response);
          return res.status(200).json(response);



        }catch{
          return res.status(error.code || 500).json(error);
        }
      }
    }




}
module.exports = CompradoresController;