require('dotenv').config(); // Garante acesso às variáveis de ambiente
const jwt = require('jsonwebtoken');

/**
 * 1. Middleware de Autenticação
 * Verifica se o token é válido e decodifica os dados.
 */
const verifyToken = (req, res, next) => {
    const authHeader = req.headers['authorization'];
    
    
    const token = authHeader && authHeader.split(' ')[1];

    if (!token) {
        return res.status(401).json({ 
            message: 'Acesso negado. Token não fornecido.' 
        });
    }

    jwt.verify(token, process.env.JWT_SECRET, (err, decoded) => {
        if (err) {
            return res.status(403).json({ 
                message: 'Token inválido ou expirado.' 
            });
        }

       
        req.user = decoded; 
        
        next(); 
    });
};

/**
 * 2. Middleware de Autorização (Role: Empresa)
 * Deve ser usado DEPOIS do verifyToken.
 */
const isEmpresa = (req, res, next) => {
    
    if (!req.user) {
        return res.status(401).json({ message: 'Usuário não autenticado.' });
    }

    
    if (req.user.role !== 'empresa') {
        return res.status(403).json({ 
            message: 'Acesso negado. Apenas contas do tipo empresa podem acessar este recurso.' 
        });
    }

    next(); 
};

module.exports = { verifyToken, isEmpresa };