const express = require("express");
const routes = express.Router();


const AuthController = require("./auth.controller");
const authController = new AuthController();

routes.post("/login", authController.login());
routes.post("/", authController.register());
routes.post("/empresa", authController.registerEmpresa());
routes.patch("/empresa/:id_empresa", authController.updateEmpresa());
routes.get("/empresas", authController.getEmpresas());
routes.get("/", authController.getLojas());
routes.get("/:id", authController.getUmaLoja());
routes.get("/status/:id_empresa", authController.getStatusEmpresa());
routes.delete("/empresa/:id_empresa", authController.deleteEmpresa());
routes.delete("/:id", authController.delete());
routes.patch("/", authController.update());



module.exports = routes;