const express = require("express");
const Auth = require("./modules/auth/auth.routes.js");
const fornecedores = require("./modules/fornecedores/fornecedores.routes.js");
const recebimentos = require("./modules/recebimentos/recebimentos.routes.js");
const engenheiros = require("./modules/engenheiros/engenheiros.routes.js");
const operarios = require("./modules/operarios/operarios.routes.js");
const indicacoes = require("./modules/indicacoes/indicacoes.routes.js");
const pedidos = require("./modules/pedidos/pedidos.routes.js");
const plantas = require("./modules/plantas/plantas.routes.js")
const atividades = require("./modules/atividades/atividades.routes.js")
const auth = require("./config/auth/auth.js");
const compradores = require("./modules/compradores/compradores.routes.js");
const orcamentos = require("./modules/orcamentos/orcamentos.routes.js");
const financeiros = require("./modules/financeiros/financeiros.routes.js")
const notas = require("./modules/notas/notas.routes.js")

const routes = express.Router();

const AuthController = require("./modules/auth/auth.controller");
const authController = new AuthController();


routes.post("/login", authController.login());
routes.post("/logout", auth.isAuthenticated, authController.logout());


routes.post("/mensagens/enviar", authController.enviarMensagemParaResponsavel());


routes.use("/auth", Auth)
routes.use("/fornecedores", fornecedores)
routes.use("/recebimentos", recebimentos)
routes.use("/engenheiros", engenheiros)
routes.use("/operarios", operarios)
routes.use("/indicacoes", indicacoes);
routes.use("/pedidos", pedidos);
routes.use("/atividades", atividades);
routes.use("/compradores", compradores);
routes.use("/plantas", plantas)
routes.use("/orcamentos", orcamentos)
routes.use("/financeiros", financeiros)
routes.use("/notas", notas)


module.exports = routes;