const mysql = require("mysql");
const fs = require('fs');

const path = require('path');
require('dotenv').config({path:__dirname+'/../../.env'});

const db = mysql.createPool({
    host: process.env.DB_HOST,
    user: process.env.DB_USERNAME,
    password: process.env.DB_PASSWORD,
    port: process.env.DB_PORT,
    database: process.env.DB_NAME,
    multipleStatements: true,
});


console.log(`Connected to database [${process.env.DB_NAME}]`);

global.db = db;

module.exports = db;